<?
/*
 * Project: NodeMap2.0
 * File: KMLHandler.class.php
 * Purpose: Creating of editing KML files
 */

class KMLFile {
	final $template = '
		<?xml version="1.0" encoding="UTF-8"?>
		<kml xmlns="http://www.opengis.net/kml/2.2">
			%CONTENT%
		</kml>';

	private $KMLPlacemarks = array();

	/*
	 * Function: __construct (constructor)
	 * Parameters: -
	 * Function: Creating a new KMLFile
	 */
	function __construct() {
	}

	function addPlacemark(KMLPlacemark $placemark) {
		$this->KMLPlacemarks[] = $placemark;
	}

	function addPlacemark(string $name, string $description, float $xcoordinate, float $ycoordinate) {
		$placemark = new KMLPlacemark();
		$placemark->setName($name);
		$placemark->setDescription($description);
		$placemark->setXCoordinate($xcoordinate);
		$placemark->setYCoordinate($ycoordinate);

		$this->KMLPlacemarks[] = $placemark;
	}

	function toString() {
		$toString = $template;

		$placemarkString = '';
		$placemarkCount = count($this->KMLPlacemarks);
		for ($i = 0; $i < $placemarkCount; $i++) {
			$placemarkString .= $this->KMLPlacemarks->toString();
		}

		$toString = preg_replace('%CONTENT%', $placemarkString, $toString);

		return $toString;
	}

	function write(string $filename) {
		// TODO: Write KMLFile to a KML file
	}
}
?>