<?
/*
 * Project: NodeMap2.0
 * File: KMLPlacemark.class.php
 * Purpose: Placemark used in KMLFile
 */

class KMLPlacemark {
	final $template = '
		<placemark>
			<name>%NAME%</name>
			<description>%DESCRIPTION%</description>
			<point>
				<coordinates>%XCOORDINATE%,%YCOORDINATE%,0</coordinates>
			</point>
		</placemark>';

	private $name;
	private $description;
	private $xCoordinate;
	private $yCoordinate;

	/*
	 * Function: __construct (constructor)
	 * Parameters: -
	 * Function: Creating a new KMLFile
	 */
	function __construct() {
	}

	function setName(string $newName) {
		$this->name = $newName;
	}

	function setDescription(string $newDescription) {
		$this->description = $newDescription;
	}

	function setXCoordinate(float $newXCoordinate) {
		$this->xCoordinate = $newXCoordinate;
	}

	function setYCoordinate(float $newYCoordinate) {
		$this->yCoordinate = $newYCoordinate;
	}

	function toString() {
		$toString = $template;

		$toString = preg_replace('%NAME%', $this->name, $toString);
		$toString = preg_replace('%DESCRIPTION%', $this->description, $toString);
		$toString = preg_replace('%XCOORDINATE%', $this->xCoordinate, $toString);
		$toString = preg_replace('%YCOORDINATE%', $this->yCoordinate, $toString);

		return $toString;
	}
}
?>