<?
/*
 * Project: NodeMap2.0
 * File: ErrorHandler.class.php
 * Purpose: Handling (PHP) errors generated by the application
 */

/*
 * PHP errors:
 *   E_ERROR ( integer )				Fatal run-time errors. These indicate errors that can not be recovered from, such as a memory allocation problem. Execution of the script is halted.	 
 *   E_WARNING ( integer )				Run-time warnings (non-fatal errors). Execution of the script is not halted.	 
 *   E_PARSE ( integer )				Compile-time parse errors. Parse errors should only be generated by the parser.	 
 *   E_NOTICE ( integer )				Run-time notices. Indicate that the script encountered something that could indicate an error, but could also happen in the normal course of running a script.	 
 *   E_CORE_ERROR ( integer )			Fatal errors that occur during PHP's initial startup. This is like an E_ERROR, except it is generated by the core of PHP.	since PHP 4
 *   E_CORE_WARNING ( integer )			Warnings (non-fatal errors) that occur during PHP's initial startup. This is like an E_WARNING, except it is generated by the core of PHP.	since PHP 4
 *   E_COMPILE_ERROR ( integer )		Fatal compile-time errors. This is like an E_ERROR, except it is generated by the Zend Scripting Engine.	since PHP 4
 *   E_COMPILE_WARNING ( integer )		Compile-time warnings (non-fatal errors). This is like an E_WARNING, except it is generated by the Zend Scripting Engine.	since PHP 4
 *   E_USER_ERROR ( integer )			User-generated error message. This is like an E_ERROR, except it is generated in PHP code by using the PHP function trigger_error().	since PHP 4
 *   E_USER_WARNING ( integer )			User-generated warning message. This is like an E_WARNING, except it is generated in PHP code by using the PHP function trigger_error().	since PHP 4
 *   E_USER_NOTICE ( integer )			User-generated notice message. This is like an E_NOTICE, except it is generated in PHP code by using the PHP function trigger_error().	since PHP 4
 *   E_STRICT ( integer )				Enable to have PHP suggest changes to your code which will ensure the best interoperability and forward compatibility of your code.	since PHP 5
 *   E_RECOVERABLE_ERROR ( integer )	Catchable fatal error. It indicates that a probably dangerous error occured, but did not leave the Engine in an unstable state. If the error is not caught by a user defined handle (see also set_error_handler()), the application aborts as it was an E_ERROR.	since PHP 5.2.0
 *   E_DEPRECATED ( integer )			Run-time notices. Enable this to receive warnings about code that will not work in future versions.	since PHP 5.3.0
 *   E_USER_DEPRECATED ( integer )		User-generated warning message. This is like an E_DEPRECATED, except it is generated in PHP code by using the PHP function trigger_error().	since PHP 5.3.0
 *   E_ALL ( integer )					All errors and warnings, as supported, except of level E_STRICT in PHP < 6.
 */

class ErrorHandler {
	/*
	 * Function: ErrorHandler
	 * Parameters: int $errno, string $errstr, string $errfile, int $errline, array $errcontext
	 * Function: Handling with errors, decides what to do with it 
	 */
	public function ErrorHandler(int $errno, string $errstr, string $errfile, int $errline, array $errcontext) {
		switch ($errno) {
			case E_ERROR:
				echo 'E_ERROR: ' , $errno , ': ' , $errstr , '<br/>Bestand: ' , $errfile , '<br/>Regel: ' , $errline , '<br/>';
				// TODO
				break;	 
			case E_WARNING:	 
				echo 'E_WARNING: ' , $errno , ': ' , $errstr , '<br/>Bestand: ' , $errfile , '<br/>Regel: ' , $errline , '<br/>';
				// TODO
				break;	 
			case E_PARSE:	 
				echo 'E_PARSE: ' , $errno , ': ' , $errstr , '<br/>Bestand: ' , $errfile , '<br/>Regel: ' , $errline , '<br/>';
				// TODO
				break;	 
			case E_NOTICE:	 
				echo 'E_NOTICE: ' , $errno , ': ' , $errstr , '<br/>Bestand: ' , $errfile , '<br/>Regel: ' , $errline , '<br/>';
				// TODO
				break;	 
			case E_CORE_ERROR:
				echo 'E_CORE_ERROR: ' , $errno , ': ' , $errstr , '<br/>Bestand: ' , $errfile , '<br/>Regel: ' , $errline , '<br/>';
				// TODO
				break;	 
			case E_CORE_WARNING:
				echo 'E_CORE_WARNING: ' , $errno , ': ' , $errstr , '<br/>Bestand: ' , $errfile , '<br/>Regel: ' , $errline , '<br/>';
				// TODO
				break;	 
			case E_COMPILE_ERROR:
				echo 'E_COMPILE_ERROR: ' , $errno , ': ' , $errstr , '<br/>Bestand: ' , $errfile , '<br/>Regel: ' , $errline , '<br/>';
				// TODO
				break;	 
			case E_COMPILE_WARNING:
				echo 'E_COMPILE_WARNING: ' , $errno , ': ' , $errstr , '<br/>Bestand: ' , $errfile , '<br/>Regel: ' , $errline , '<br/>';
				// TODO
				break;	 
			case E_USER_ERROR:
				echo 'E_USER_ERROR: ' , $errno , ': ' , $errstr , '<br/>Bestand: ' , $errfile , '<br/>Regel: ' , $errline , '<br/>';
				// TODO
				break;	 
			case E_USER_WARNING:
				echo 'E_USER_WARNING: ' , $errno , ': ' , $errstr , '<br/>Bestand: ' , $errfile , '<br/>Regel: ' , $errline , '<br/>';
				// TODO
				break;	 
			case E_USER_NOTICE:
				echo 'E_USER_NOTICE: ' , $errno , ': ' , $errstr , '<br/>Bestand: ' , $errfile , '<br/>Regel: ' , $errline , '<br/>';
				// TODO
				break;	 
			case E_STRICT:
				echo 'E_STRICT: ' , $errno , ': ' , $errstr , '<br/>Bestand: ' , $errfile , '<br/>Regel: ' , $errline , '<br/>';
				// TODO
				break;	 
			case E_RECOVERABLE_ERROR:
				echo 'E_RECOVERABLE_ERROR: ' , $errno , ': ' , $errstr , '<br/>Bestand: ' , $errfile , '<br/>Regel: ' , $errline , '<br/>';
				// TODO
				break;	 
			case E_DEPRECATED:
				echo 'E_DEPRECATED: ' , $errno , ': ' , $errstr , '<br/>Bestand: ' , $errfile , '<br/>Regel: ' , $errline , '<br/>';
				// TODO
				break;	 
			case E_USER_DEPRECATED:
				echo 'E_USER_DEPRECATED: ' , $errno , ': ' , $errstr , '<br/>Bestand: ' , $errfile , '<br/>Regel: ' , $errline , '<br/>';
				// TODO
				break;	 
			default:
				echo 'E_DEFAULT: ' , $errno , ': ' , $errstr , '<br/>Bestand: ' , $errfile , '<br/>Regel: ' , $errline , '<br/>';
				// TODO
				break;	 
		}

		/* Don't execute PHP internal error handler */
		return true;
	}
}

set_exception_handler('ErrorHandler::ErrorHandler');