<?php
require_once('config.php');
require_once($config['root'] . '/map/inc/kmlHandler.php');
require_once($config['root'] . '/map/inc/node_info_start.php');
require_once($config['root'] . '/map/inc/search_node.php');

// Getting array from kmlHandler
$markers = get_node_array($config['kml_file']);

// Key is defined to be the domain name if exists
$apikey = $config['googlekey']['default'];
$servername = $_SERVER['SERVER_NAME'];

# Little hack, does not work with foo.co.uk domains
$servername = implode('.',array_slice(explode('.',$servername),-2));
if (array_key_exists($servername,$config['googlekey'])) {
	$apikey = $config['googlekey'][$servername];
}
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html lang="dutch">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<title>Nodemap Wireless Leiden</title>
<!-- External stylesheet for all browsers -->
<link href="style/stylesheet.css" rel="stylesheet" type="text/css">
<!-- Using stylesheet2.css when browser is any version of Microsoft Internet Explorer -->
<!--[if IE]>
	<link href="style/stylesheet2.css" rel="stylesheet" type="text/css">
<![endif]-->

<!-- Make our $marker[] array from kmlHandler available to javascript in JSON (No idea on how to this another less ugle way)-->
<script type="text/javascript">
var markers = <?php echo json_encode($markers); ?>;
</script>

<!-- Loading in the google-api -->
<script
	src="http://maps.google.com/maps?file=api&amp;v=2&amp;key=<?php print $apikey;?>"
	type="text/javascript"></script>
<!-- Loading in the markerClusterer that will handle the clustering of markers. -->
<script type="text/javascript" src="inc/markerClusterer.js"></script>
<!-- Loading in the javascript that will add the map into #mapcanvas -->
<script type="text/javascript" src="inc/nodemapWL.js"></script>
<script type="text/javascript" src="inc/overlay.js"></script>
<script type="text/javascript" src="inc/iconStyles.js"></script>

<!-- Loading in the javascript that handles the switching between gebruiker and beheerder -->
<script type="text/javascript" src="inc/gebruiker_beheerder_switch.js"></script>

</head>
<body onload="suggestMarkers('')">
<!-- Mainwrapper contains all content on the page -->
<div id="mainwrapper"><!-- Mapcanvas is the container where the map will be put in. Height and width of map is specified by size of the div -->
<div id="mapcanvas"><!-- Create the map using the intitialize_map() function from nodemapWL.js -->
<script type="text/javascript">initialize_map();</script> <!--<script type="text/javascript">nodeAdd();</script>-->
</div>
<div id="infowrapper"><!-- Top information space -->
<div id="infotop"><!-- Calling on the node information from an external php file. inc/node_info.php -->
<?php node_info_start(); ?></div>

<!-- Bottom information space -->
<div id="infobottom"><?php searchNodes(); ?>
<div id="searchlist"></div>
</div>
<!-- The buttons under the searchframe. In a table for positioning. -->
<div id="userpick">
<table>
	<tr>
		<!-- onclick events activate functions from within inc/gebruiker_beheerder_switch.js which load in the selected view with node_info.php -->
		<td><input type="button" value="Gebruiker"
			onclick="switchGebruiker();"></td>
		<td><input type="button" value="Beheerder"
			onclick="switchBeheerder();"></td>
	</tr>
</table>
</div>
</div>

<!-- General functions under the map -->
<div id="navigation">
<form action="">
<table>
	<tr>
		<!-- First colum -->
		<td><input type="checkbox" value="shownodes"
			onclick="toggleAllNodes();" checked="checked">Toon nodes</td>
		<!-- Second colum -->
		<td><input type="checkbox" value="showrange">Toon dekking <br>
		<input type="checkbox" value="showtraffic">Toon dataverkeer</td>
		<td><input type="checkbox" value="gsearchbar"
			onclick="toggleGoogleSearchMap();">Toon locatie zoeken</td>
	</tr>
</table>
</form>
</div>
</div>
</body>
</html>