<?php
require_once("../../config.php");
require_once($config['root']."/map/inc/kmlHandler.php");

if(isset($_GET['view']))
{
	setcookie("view", $_GET['view']); 
	header('P3P: CP="IDC DSP COR CURa ADMa OUR IND PHY ONL COM STA"'); 
	$view = $_GET['view'];
}
else
{
	if(isset($_COOKIE['view']))
	{
		$view = $_COOKIE['view'];
	}
	else
		$view = "gebruiker";
}

if(isset($_GET['sel']))
{
	$selected = $_GET['sel'];
}
else
{
	$selected = "";
}

//TYPES of nodes. 'cluster' is a cluster node. 'single' is an individual node.
if(!isset($_GET['type']))//
{
	echo <<<EOF
		<div id="nodeinfo">
			<b>Mouse over</b> een node voor meer informatie.<br><br>
			<b>Klik</b> op een node om deze te selecteren.<br><br>
			Gebruik de <b>zoekfunctie</b> om de een specifieke node te zoeken.
		</div>
		<div id="timestamp">
			Laatste update: 15:42 <br>
			Do 25 maart
		</div>
EOF;
	
}
elseif($_GET['type'] == "single") //Info for single nodes is stored here
{
$markers = get_node_array($config['kml_file']);

$description;

foreach($markers as $marker)
{
	if(!$marker['location'] == null)
	{
		if($marker['name'] == $_GET['name'])
		{
			$name = $marker['name'];
			$location = $marker['location'];
			$status = $marker['status'];
			$interfaces = $marker['interfaces'];
			$masterIP = $marker['masterIP'];
			$nodeType = $marker['nodeType'];
			$type = $marker['type'];
			$hostname = $marker['hostname'];
			$hasBeenChecked = $marker['hasBeenChecked'];
			$checkExecutionTime = $marker['checkExecutionTime'];
			$currentState = $marker['currentState'];
			$problemHasBeenAcknowledged = $marker['problemHasBeenAcknowledged'];
			
			$lastcheck = $marker['lastCheck'];
			$lastcheck = date('d-m-Y H:i:s', (int)$lastcheck);

		}
	}
}

	if($view == "beheerder")//Display part for beheerder view of a single node
	{	
		echo <<<EOF
		<div id='nodeinfo'>
		<b>{$name}</b>
			<div id="information">
			<p>Locatie: {$location}
			<p>Status: {$status}
			<p>Inferfaces: {$interfaces}
			<p>Master IP: {$masterIP}
			<p>Node type: {$nodeType}
			<p>Type: {$type}
			<p>Hostname: {$hostname}
			<p>Has been check: {$hasBeenChecked}
			<p>Check execution time: {$checkExecutionTime}
			<p>Current state: {$currentState}
			<p>Problem has been acknowledged: {$problemHasBeenAcknowledged}
		</div>
		<div id="timestamp">
			Laatste update: {$lastcheck}	
		</div>
EOF;
	}
	elseif($view == "gebruiker")//Display part for gebruiker view of a single node
	{
		echo <<<EOF
		<div id='nodeinfo'>
		<b>{$name}</b>
			<div id="information">
			<p>Locatie: {$location}
			<p>Status: {$status}
			<p>Type: {$type}
			<p>Hostname: {$hostname}
		</div>
		<div id="timestamp">
			Laatste update: 15:42 <br>
			Do 25 maart
		</div>
EOF;
	}
}	
elseif($_GET['type'] == "cluster")
{
	$markerTitles = unserialize($_GET['markers']);
	
	echo <<<EOF
	<div id="nodeinfo">
		<b>Nodes:</b><br/>
	
		Lijst met nodes in deze cluster<br>
		<div id="clusterlist$selected" >
		<select multiple onchange='goToMarker(this.options[this.selectedIndex].text)'>
EOF;
	foreach($markerTitles as $marker)
	{
		echo "<option value='".$marker."'>".$marker."</option>";
	}

	echo <<<EOF
		</select>
		</div>
	</div>
EOF;
}	
?>
