<?php
//$file contains place of the KML file we will be getting our node information from
function get_node_array($file)
{
	//Check if the file exists, if it does we load it. If it doesn't we exit and return an error message
	if (file_exists($file)) 
	{
		$xml = simplexml_load_file($file);
	} 
	else 
	{
		exit('Failed to open'.$file);
	}

	//Counter starts at 0. For every foreach done counter will go up by one. Thus resulting in total nodes added(counter starts at 0 so add 1 to the total )
	$counter = 0;

	//Now we go through the xml files, storing the data in an array called $markers. More data can be stored by adding more rows in the array 
	foreach($xml->Document->Folder->Placemark as $placemark)
	{
		/*
		 * Getting all data from the datatags in the KML file.
		 * First we declare variables we will use.
		 * Then we itirate trough all the data and fill the variables
		 */
		$location = "";
		$status = "";
		$interfaces = "";
		$masterIP = "";
		$nodeType = "";
		$type = "";
		$hostname = "";
		$hasBeenChecked = "";
		$checkExecutionTime = "";
		$currentState = "";
		$lastCheck = "";
		$problemHasBeenAcknowledged = "";
		
		foreach($placemark->ExtendedData->Data as $data)
		{
			foreach($data->attributes() as $nameAttribute => $name)
			{
				if($name == "location")
					$location = $data->value;
				
				if($name == "status")
					$status = $data->value;
				
				if($name == "interfaces")
					$interfaces = $data->value;

				if($name == "masterIP")
					$masterIP = $data->value;
					
				if($name == "nodeType")
					$nodeType = $data->value;
					
				if($name == "type")
					$type = $data->value;
					
				if($name == "hostName")
					$hostname = $data->value;
					
				if($name == "hasBeenChecked")
					$hasBeenChecked = $data->value;	
					
				if($name == "checkExecutionTime")
					$checkExecutionTime = $data->value;
					
				if($name == "lastCheck")
					$lastCheck = $data->value;
					
				if($name == "currentState")
					$currentState = $data->value;
					
				if($name == "problemHasBeenAcknowledged")
					$problemHasBeenAcknowledged = $data->value;
			}
		}
		
		/*
		 * We now fill up our array with Longitude and Latitude and Name by accessing $placemark
		 * Then we fill the rest of the array with the variables we declared and filled earlier
		 */
		
		$markers[] = array(	"latitude"=>$placemark->LookAt->latitude,
							"longitude"=>$placemark->LookAt->longitude,
							"name"=>$placemark->name,
							"location"=>$location,
							"status"=>$status,
							"interfaces"=>$interfaces,
							"masterIP"=>$masterIP,
							"nodeType"=>$nodeType,
							"type"=>$type,
							"hostname"=>$hostname,
							"hasBeenChecked"=>$hasBeenChecked,
							"checkExecutionTime"=>$checkExecutionTime,
							"currentState"=>$currentState,
							"lastCheck"=>$lastCheck,
							"problemHasBeenAcknowledged"=>$problemHasBeenAcknowledged);
	}
	return $markers;
}