function drawCircle(lat, lng, radius, strokeColor, strokeWidth, strokeOpacity, fillColor, fillOpacity) {   
    
    var d2r = Math.PI/180;
    var r2d = 180/Math.PI;
    var Clat = radius * 0.0089437672;  // Convert statute kilometers into degrees latitude
    var Clng = Clat/Math.cos(lat*d2r); 
    var Cpoints = []; 
    for (var i=0; i < 33; i++) { 
      var theta = Math.PI * (i/16);
      Cy = lat + (Clat * Math.sin(theta));
      Cx = lng + (Clng * Math.cos(theta));
      var P = new GLatLng(Cy, Cx);
      Cpoints.push(P);
    }

    polygon = new GPolygon(Cpoints, strokeColor, strokeWidth, strokeOpacity, fillColor, fillOpacity);
    
    
    return polygon;
   }



function highlightCurrentMarker(){
var markerPoint = currentMarker.getPoint();

var polyPoints = Array();

if (highlightCircle) {
 map.removeOverlay(highlightCircle);
}

var mapNormalProj = G_NORMAL_MAP.getProjection();
var mapZoom = map.getZoom();
var clickedPixel = mapNormalProj.fromLatLngToPixel(markerPoint, mapZoom);

var polySmallRadius = 20;

var polyNumSides = 20;
var polySideLength = 18;

for (var a = 0; a<(polyNumSides+1); a++) {
 var aRad = polySideLength*a*(Math.PI/180);
 var polyRadius = polySmallRadius; 
	    var pixelX = clickedPixel.x + polyRadius * Math.cos(aRad);
 var pixelY = clickedPixel.y + polyRadius * Math.sin(aRad);
 var polyPixel = new GPoint(pixelX,pixelY);
 var polyPoint = mapNormalProj.fromPixelToLatLng(polyPixel,mapZoom);
 polyPoints.push(polyPoint);
}
// Using GPolygon(points,  strokeColor?,  strokeWeight?,  strokeOpacity?,  fillColor?,  fillOpacity?)
highlightCircle = new GPolygon(polyPoints,"#000000",2,0.0,"#F7FE2E",.5);
map.addOverlay(highlightCircle);
}
