<?php
require_once("../../config.php");
require_once($config['root']."/map/inc/kmlHandler.php");
/*
 * Get the array containing all the nodes
 */
$markers = get_node_array($config['kml_file']);


$suggested_markers = array();

/*
 * Get the value that has been sent in the url, if theres no value in the url, the value will be nothing.
 */
if(isset($_GET['value']))
{
	$typed_value = $_GET['value'];
}
else
{
	$typed_value = "";
}

/*
 * Fill the markernames array with all the names from markers we have on the map.
 */
foreach($markers as $marker)
{
	$markernames[] = (string)$marker['name'];
}

/*
 * If the typed value is equal to the first part of a node name, the nodename is inserted into the $suggested_markers array
 */
if (strlen($typed_value) > 0)
{
  for($i=0; $i<count($markernames); $i++)
    {
		$hint= "";
		if (strtolower($typed_value)==strtolower(substr($markernames[$i],0,strlen($typed_value))))
		{
			$suggested_markers[]=$markernames[$i];
		}
   }
}

/*
 * If there are no suggested markers, check if there is something that has been typed.
 * If so there are no suggestions found.
 * Else there has been nothing typed, so we show all the markers we have.
 */
if ($suggested_markers == null)
{
	if (strlen($typed_value) > 0)
	{
		$suggested_markers[] = "Geen suggesties";
	}
	else
	{
		$suggested_markers = $markernames;
	}
}

/*
 * Make a list with all the suggested markers we have. 
 * onchange we call the goToMarker function in nodemapWL.js and set the constructor with the value of the selected option.
 */
echo "<select multiple onchange='goToMarker(this.options[this.selectedIndex].text)'>";
foreach($suggested_markers as $name)
{
	$name = (string)$name;
	echo "<option value='{$name}' >{$name}</option>";
}
echo "</select>";

?>


	
