<?php
/*
 * Project: NodeMap2.0
 * File: NetworkList.class.php
 * Purpose: Contains a list of Network objects
 */

class NetworkList {
	private $networks;		// Array of Network objects

	/*
	 * Function: __construct (constructor)
	 * Description: Creating a new NetworkList object
	 * Parameters: -
	 * Returns: -
	 */
	public function __construct() {
		// Create an empty network array
		$this->networks = array();
	}

	/*
	 * Function: add
	 * Description: Adds a network to our list
	 * Parameters: Network $newNetwork
	 * Returns: -
	 */
	function add(Network $newNetwork) {
		// Add Network $newNetwork to the array
		$this->networks[] = $newNetwork;
	}

	/*
	 * Function: get
	 * Description: Gets the network on a specific number
	 * Parameters: int $i
	 * Returns: Network if $i is in the range of the array, otherwise false
	 */
	function get($i) {
		if (($i >= 0) && ($i < count($this->networks))) {
			return $this->networks[$i];
		} else {
			return false;
		}
	}

	/*
	 * Function: find
	 * Description: Find the position of a network using a IP within the range of network
	 * Parameters: string $ip
	 * Returns: Position of the network if found, otherwise false
	 */
	function find($ipAddress) {
		$networkCount = count($this->networks);
		for ($i = 0; $i < $networkCount; $i++) {
			if ($this->networks[$i]->inNetwork($ipAddress)) {
				return $i;
			}
		}

		// Not found
		return false;
	}
}
?>