<?php
/*
 * Project: NodeMap2.0
 * File: kml-echo.php
 * Purpose: Echo our KML file directly (great for testing)
 */

require_once('config.php');
require_once($config['file_init']);

// Make it parse properly within Firefox so that it will display a DOM tree
header('Content-Type: text/xml');
echo '<?xml version="1.0" encoding="UTF-8"?>';

// Let's try reading from files and parsing the data in the files.
// First off, we create a new KMLFile object
$kmlFile = new KMLFile();

// Let's try to read the node location file
$nodeLocation = new FileHandler($config['node_location_file'], 'r');
$kmlFile->parseLocationFile($nodeLocation->read());

// Let's try to read the node status file
$nodeStatus = new FileHandler($config['node_status_file'], 'r');
$kmlFile->parseStatusFile($nodeStatus->read());

// And echo the result to the screen
echo $kmlFile->toString();
?>
