<?php
require_once($config['root']."/inc/LogHandler.class.php");

function getArrayFromKML()
{
global $config;
$file = $config['kml_file'];

	//Check if the file exists, if it does we load it. If it doesn't we exit and return an error message
	if (file_exists($file)) 
	{
		$xml = simplexml_load_file($file);
	} 
	else 
	{
		trigger_log(SYSLOG_CRIT, "Failed to open KML file $file", __FILE__, __LINE__);
	}

	//Counter starts at 0. For every foreach done counter will go up by one. Thus resulting in total nodes added(counter starts at 0 so add 1 to the total )
	$counter = 0;

	//Now we go through the xml files, storing the data in an array called $markers. More data can be stored by adding more rows in the array 
	foreach($xml->Document->Folder->Placemark as $placemark)
	{
		
		$markers[(string)$placemark->name] = array(	"latitude"=>$placemark->LookAt->latitude,
							"longitude"=>$placemark->LookAt->longitude,
							"name"=>$placemark->name,
							"description"=>$placemark->description,
							"id"=>$counter);
		$counter++;			
	}
	return $markers;
}