<?php
/*
 * Project: NodeMap2.0
 * File: KMLPlacemark.class.php
 * Purpose: Placemark used in KMLFile
 */

define('LINE_BLACK', 'blackLine');

class KMLLine {
	private $template = '
		<Placemark id="%ID%">
			<name>%NAME%</name>
			<description>
				<![CDATA[
					<img src="http://www.wirelessleiden.nl/sites/wirelessleiden.nl/files/garland-wl_logo.png" alt="Wireless Leiden" title="Wireless Leiden" style="float: right;"/>
					%DESCRIPTION%
				]]>
			</description>
			<LookAt>
				<longitude>%LONGITUDE%</longitude>
				<latitude>%LATITUDE%</latitude>
				<altitude>0</altitude>
				<heading>0</heading>
				<tilt>0</tilt>
				<range>500</range>
			</LookAt>
			<styleUrl>%STYLE%</styleUrl>
			<LineString>
				<coordinates>
					%X1%, %Y1%, 0. 
					%X2%, %Y2%, 0.
				</coordinates>
			</LineString>
		</Placemark>';

	private $id;					// ID of the line
	private $name;					// Name of the line
	private $description;			// Description of the line
	private $longitude;				// Longitude of the line
	private $latitude;				// Latitude of the line
	private $style;					// Style of the line
	private $x1;					// Start X of line
	private $y1;					// Start Y of line
	private $x2;					// End X of line
	private $y2;					// End Y of line

	/*
	 * Function: __construct (constructor)
	 * Description: Creating a new KMLLine
	 * Parameters: -
	 * Returns: -
	 */
	function __construct() {
		$this->id = '';
		$this->name = '';
		$this->description = '';
		$this->longitude = 0;
		$this->latitude = 0;
		$this->style = LINE_BLACK;
		$this->x1 = 0;
		$this->y1 = 0;
		$this->x2 = 0;
		$this->y2 = 0;
	}

	/*
	 * Function: setID
	 * Description: Setting the ID of the placemark
	 * Parameters: string $newID
	 * Returns: -
	 */
	function setID($newID) {
		$this->id = $newID;
	}

	/*
	 * Function: setName
	 * Description: Setting the name of the placemark
	 * Parameters: string $newName
	 * Returns: -
	 */
	function setName($newName) {
		$this->name = $newName;
	}

	/*
	 * Function: getName
	 * Description: Getting the name of the placemark
	 * Parameters: -
	 * Returns: The name of the placemark
	 */
	function getName() {
		return $this->name;
	}

	/*
	 * Function: setDescription
	 * Description: Setting the description of the placemark
	 * Parameters: string $newDescription
	 * Returns: -
	 */
	function setDescription($newDescription) {
		$this->description = (string) $newDescription;
	}

	/*
	 * Function: setLongitude
	 * Description: Setting the longitude of the placemark
	 * Parameters: double $newLongitude
	 * Returns: -
	 */
	function setLongitude($newLongitude) {
		$this->longitude = (double) $newLongitude;
	}

	/*
	 * Function: setLatitude
	 * Description: Setting the latitude of the placemark
	 * Parameters: double $newLatitude
	 * Returns: -
	 */
	function setLatitude($newLatitude) {
		$this->latitude = (double) $newLatitude;
	}

	/*
	 * Function: setStyle
	 * Description: Setting the style of the placemark
	 * Parameters: string $newStyle
	 * Returns: -
	 */
	function setStyle($newStyle) {
		$this->style = (string) $newStyle;
	}

	/*
	 * Function: setX1
	 * Description: Setting the X1 of the placemark
	 * Parameters: double $newX1
	 * Returns: -
	 */
	function setX1($newX1) {
		$this->x1 = (double) $newX1;
	}
	
	/*
	 * Function: setY1
	 * Description: Setting the Y1 of the placemark
	 * Parameters: double $newY1
	 * Returns: -
	 */
	function setY1($newY1) {
		$this->y1 = (double) $newY1;
	}
	
	/*
	 * Function: setX2
	 * Description: Setting the X2 of the placemark
	 * Parameters: double $newX2
	 * Returns: -
	 */
	function setX2($newX2) {
		$this->x2 = (double) $newX2;
	}
	
	/*
	 * Function: setY2
	 * Description: Setting the Y2 of the placemark
	 * Parameters: double $newY2
	 * Returns: -
	 */
	function setY2($newY2) {
		$this->y2 = (double) $newY2;
	}

	/*
	 * Function: toString
	 * Description: Converts the content of this placemark to a KML valid string
	 * Parameters: -
	 * Returns: KML valid string
	 */
	function toString() {
		$toString = $this->template;

		$toString = str_replace('%ID%', $this->id, $toString);
		$toString = str_replace('%NAME%', $this->name, $toString);
		$toString = str_replace('%DESCRIPTION%', $this->description, $toString);
		$toString = str_replace('%LONGITUDE%', $this->longitude, $toString);
		$toString = str_replace('%LATITUDE%', $this->latitude, $toString);
		$toString = str_replace('%STYLE%', $this->style, $toString);
		$toString = str_replace('%X1%', $this->x1, $toString);
		$toString = str_replace('%Y1%', $this->y1, $toString);
		$toString = str_replace('%X2%', $this->x2, $toString);
		$toString = str_replace('%Y2%', $this->y2, $toString);

		return $toString;
	}
}
?>