<?php
/*
 * Project: NodeMap2.0
 * File: LogHandler.class.php
 * Purpose: Handling our log file containing log entries generated by the application
 */

/*
 * Log levels:
 *   SYSLOG_EMERG		System is unusable
 *   SYSLOG_ALERT		Action must be taken immediately
 *   SYSLOG_CRIT		Critical conditions
 *   SYSLOG_ERR		Error conditions
 *   SYSLOG_WARNING	Warning conditions
 *   SYSLOG_NOTICE		Normal, but significant, condition
 *   SYSLOG_INFO		Informational message
 *   SYSLOG_DEBUG		Debug-level message
 */

define('SYSLOG_NONE', 0);
define('SYSLOG_EMERG', 1);
define('SYSLOG_ALERT', 2);
define('SYSLOG_CRIT', 3);
define('SYSLOG_ERR', 4);
define('SYSLOG_WARNING', 5);
define('SYSLOG_NOTICE', 6);
define('SYSLOG_INFO', 7);
define('SYSLOG_DEBUG', 8);

/*
 * Actions on log levels
 */
define('LOG_LEVEL_ECHO', SYSLOG_DEBUG);
define('LOG_LEVEL_WRITE', SYSLOG_DEBUG);
define('LOG_LEVEL_MAIL', SYSLOG_DEBUG);

class LogHandler {
	/*
	 * Function: __construct (constructor)
	 * Parameters: -
	 * Function: Creating a LogHandler object
	 */
	public function __construct() {
	}

	/*
	 * Function: logEntry
	 * Parameters: int $logno, string $logstr, string $logfile, int $logline
	 * Function: Handling with log entries, decides what to do with it
	 */
	public function logEntry($logno, $logstr, $logfile, $logline) {
		$errorString = 'SysLog ';

		switch ($logno) {
			case SYSLOG_EMERG:
				$errorString = 'Emergency';
				break;
			case SYSLOG_ALERT:
				$errorString = 'Alert';
				break;
			case SYSLOG_CRIT:
				$errorString = 'Critical';
				break;
			case SYSLOG_ERR:
				$errorString = 'Error';
				break;
			case SYSLOG_WARNING:
				$errorString = 'Warning';
				break;
			case SYSLOG_NOTICE:
				$errorString = 'Notice';
				break;
			case SYSLOG_INFO:
				$errorString = 'Information';
				break;
			case SYSLOG_DEBUG:
				$errorString = 'Debug';
				break;
			default:
				$errorString = 'SYSLOG_DEFAULT';
				break;
		}

		$time = date( "H:i.s m/d/y" );
		$errorString .= ' (' . $logno .' | '.$time .' | ): ' . $logstr . "\r\n\t" . 'In file "' . $logfile . '" on line "' . $logline . '"' . "\r\n";

		if ($logno <= LOG_LEVEL_ECHO) {
			echo '<!-- ' . $errorString . ' -->';
		}
		if ($logno <= LOG_LEVEL_WRITE) {			
			$filename = 'logfile.txt';
			if (is_writable($filename)) {
				
				//Check if the file can be opened
				  if (!$handle = fopen($filename, 'w')) {
				  	define('LOG_LEVEL_WRITE', LOG_LEVEL_NONE);
					 trigger_log(SYSLOG_EMERG, 'Cannot open file "' . $filename . '"', __FILE__, __LINE__);
					 exit;
				}
			
				// Write $errorString to file.
				if (fwrite($handle, $errorString) === FALSE) {
					define('LOG_LEVEL_WRITE', LOG_LEVEL_NONE);
					trigger_log(SYSLOG_EMERG, 'Cannot write to "' . $filename . '"', __FILE__, __LINE__);
					exit;
				}
			
				fclose($handle);
			
			} else {
				define('LOG_LEVEL_WRITE', LOG_LEVEL_NONE);
					trigger_log(SYSLOG_EMERG, 'Cannot write to "' . $filename . '"', __FILE__, __LINE__);
			}
		}
		
		if ($logno <= LOG_LEVEL_MAIL) {
			mail('test@test.com', 'Nodemap error', $errorString);
		}
	}
}

$LOG_HANDLER = new LogHandler();

/*
 * Function: trigger_log
 * Parameters: int $logno, string $logstr, string $logfile, int $logline
 * Function: Handling with log entries, forwarding them to our $LOG_HANDLER object.
 */
function trigger_log($logno, $logstr, $logfile, $logline) {
	global $LOG_HANDLER;

	$LOG_HANDLER->logEntry($logno, $logstr, $logfile, $logline);
}
?>