//Declaring some variables we will be using
var map;
var toggleState = 1;
var marker_hash = {};
var markerArray = new Array();
var xmlhttp;
var targetDiv = "infotop";

//This function is called from index.php
function initialize_map() {
	//We will only do this function if the browser is compatible
	if (GBrowserIsCompatible()) {
	//Adding the google map into the div called #mapcanvas
	map = new GMap2(document.getElementById("mapcanvas"));
	//Center the map on Leiden
	map.setCenter(new GLatLng(52.162687, 4.493294), 11); 
	map.setUIToDefault();

	//Go through the array 'markers' (Declared in index.php) and add a marker for each marker stored in the array using our addMarker function
	for (var i=0; i<markers.length; i++) {
		var current = markers[i];
		var marker  = addMarker(current, i);
		marker_hash[current.id] = {marker : marker};
	}
	
	var markerClusterer = new MarkerClusterer(map, markerArray);
  }
} 

//This function will contain the displaying and not displaying of nodes on the map
function toggleMyKml() {

}

//This function adds a marker with an object from our 'marker'array defined in index.php
function addMarker(current, i) {
	var id = current.id;
	var marker  = new GMarker(new GLatLng(current.latitude[0], current.longitude[0]), {title: id});
	//Added mouseover listener that calls on our mouseOver function when the mouse moves over a marker on the map
	GEvent.addListener(marker, 'mouseover', function() {
	mouseOver(current.id, current.name[0]);
	});
	markerArray[i] = marker;
	return marker;
}

//Our mouseover function for single nodes. Gives the ID(our own given ID) and the name of the node.
function mouseOver(id, name)
{
	//this.obj = document.getElementById("infotop");
	loadXMLDoc("inc/node_info.php?type=single")
	//We will replace this function with a httprequest to a php file in the future
	
	
	/*
	*Hieronder verdergaan met dekking
	*/
}

//Our mouseover function for Cluster nodes. 'markers' is an array containing all markers within the cluster
function mouseOverCluster(markers)
{
	var markerTitles = new Array;
	for(var i=0; i<markers.length; i++) {
		markerTitles.push(markers[i].marker.getTitle());
	}
	
	loadXMLDoc("inc/node_info.php?type=cluster")
	/*
	*Hieronder verdergaan met dekking
	*/
}


//Code from w3schools. http://www.w3schools.com/dom/dom_http.asp
function loadXMLDoc(url)
{
xmlhttp=null;
if (window.XMLHttpRequest)
  {// code for Firefox, Opera, IE7, etc.
  xmlhttp=new XMLHttpRequest();
  }
else if (window.ActiveXObject)
  {// code for IE6, IE5
  xmlhttp=new ActiveXObject("Microsoft.XMLHTTP");
  }
if (xmlhttp!=null)
  {
  xmlhttp.onreadystatechange=state_Change;
  xmlhttp.open("GET",url,true);
  xmlhttp.send(null);
  }
else
  {
  alert("Your browser does not support XMLHTTP.");
  }
}

function state_Change()
{
if (xmlhttp.readyState==4)
  {// 4 = "loaded"
  if (xmlhttp.status==200)
    {// 200 = "OK"
    document.getElementById(targetDiv).innerHTML=xmlhttp.responseText;
    }
  else
    {
    alert("Problem retrieving data:" + xmlhttp.statusText);
    }
  }
}
