<?php
/*
 * Project: NodeMap2.0
 * File: index.php
 * Purpose: Main index file of application
 */

require_once('config.php');
require_once($config['file_init']);

// Creating a placemark using our class
$kmlPlacemark1 = new KMLPlacemark();
$kmlPlacemark1->setName('Test name');
$kmlPlacemark1->setDescriptionLocation('Test location description');
$kmlPlacemark1->setDescriptionStatus('Test status description');
$kmlPlacemark1->setLatitude(52.138476);
$kmlPlacemark1->setLongitude(4.463046);
$kmlPlacemark1->setStyle(PLACEMARK_GREEN);

// Creating a second placemark using our class
$kmlPlacemark2 = new KMLPlacemark();
$kmlPlacemark2->setName('Placemark 2 name');
$kmlPlacemark2->setDescriptionLocation('This is the second placemark location description');
$kmlPlacemark2->setDescriptionStatus('This is the second placemark status description');
$kmlPlacemark2->setLatitude(52.638476);
$kmlPlacemark2->setLongitude(4.063046);
$kmlPlacemark2->setStyle(PLACEMARK_ORANGE);

// Creating a KMLFile using our class, add our placemarks and echo
$kml = new KMLFile();
$kml->addPlacemark($kmlPlacemark1);
$kml->addPlacemark($kmlPlacemark2);
/*
 * For testing, echo the example KML file
 * echo $kml->toString();
 * echo "\r\n\r\n\r\n\r\n\r\n -------------------------------------------------- \r\n\r\n\r\n\r\n\r\n";
 */

// Now let's try reading from files and parsing the data in the files.
// First off, we create a new KMLFile object
$kmlFile = new KMLFile();

// Let's try to read the node location file
$nodeLocation = new FileHandler($config['node_location_file']);
$kmlFile->parseLocationFile($nodeLocation->getFile());
/*
 * For testing, echo the example KML file
 * echo $kmlFile->toString();
 * echo "\r\n\r\n\r\n\r\n\r\n -------------------------------------------------- \r\n\r\n\r\n\r\n\r\n";
 */

// Let's try to read the node status file
$nodeStatus = new FileHandler($config['node_status_file']);
$kmlFile->parseStatusFile($nodeStatus->getFile());

// And echo the result to the screen
echo $kmlFile->toString();
?>