<?php
/*
 * Project: NodeMap2.0
 * File: KMLPlacemark.class.php
 * Purpose: Placemark used in KMLFile
 */

class KMLPlacemark {
	private $template = '
		<Placemark>
			<name>%NAME%</name>
			<visibility>0</visibility>
			<description>%DESCRIPTION%</description>
			<LookAt>
				<longitude>%LONGITUDE%</longitude>
				<latitude>%LATITUDE%</latitude>
				<altitude>0</altitude>
				<heading>0</heading>
				<tilt>0</tilt>
				<range>500</range>
			</LookAt>
			<styleUrl>%STYLE%</styleUrl>
			<Point>
				<altitudeMode>relativeToGround</altitudeMode>
				<coordinates>%LONGITUDE%,%LATITUDE%</coordinates>
			</Point>
		</Placemark>';

	private $name;					// Name of the node
	private $descriptionLocation;	// Location information of the node
	private $descriptionStatus;		// Status information of the node
	private $longitude;				// Longitude of the node
	private $latitude;				// Latitude of the node
	private $style;					// Style of the placemark

	/*
	 * Function: __construct (constructor)
	 * Parameters: -
	 * Function: Creating a new KMLFile
	 */
	function __construct() {
		$this->name = '';
		$this->descriptionLocation = '';
		$this->descriptionStatus = '';
		$this->longitude = 0;
		$this->latitude = 0;
		$this->style = 'orangeArrowIcon';
	}

	function setName($newName) {
		$this->name = $newName;
	}

	function getName() {
		return $this->name;
	}

	function setDescriptionLocation($newDescriptionLocation) {
		$this->descriptionLocation = (string) $newDescriptionLocation;
	}

	function setDescriptionStatus($newDescriptionStatus) {
		$this->descriptionStatus = (string) $newDescriptionStatus;
	}

	function setLongitude($newLongitude) {
		$this->longitude = (double) $newLongitude;
	}

	function setLatitude($newLatitude) {
		$this->latitude = (double) $newLatitude;
	}

	function setStyle($newStyle) {
		$this->style = (string) $newStyle;
	}

	function toString() {
		$toString = $this->template;

		$toString = str_replace('%NAME%', $this->name, $toString);
		$toString = str_replace('%DESCRIPTION%', $this->descriptionLocation . $this->descriptionStatus, $toString);
		$toString = str_replace('%LONGITUDE%', $this->longitude, $toString);
		$toString = str_replace('%LATITUDE%', $this->latitude, $toString);
		$toString = str_replace('%STYLE%', $this->style, $toString);
		
		return $toString;
	}
}
?>